﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ReportParametersControl.ascx.cs" Inherits="controls_ReportParametersControl" %>
<%@ Register TagPrefix="rsweb" Namespace="Microsoft.Reporting.WebForms" %>
<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845DCD8080CC91"
    Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>
 
<asp:ValidationSummary ID="ValidationSummaryReferralOverviewReport"  runat="server"
    TabIndex="1" 
    ValidationGroup="OnRunReport"
    HeaderText="The page has the following data errors:" 
    DisplayMode="BulletList" 
    ShowSummary="false" 
    ShowMessageBox="True" />
<asp:Panel ID="Panel2" runat="server"  
    GroupingText=" Selection Criteria " 
    Width="100%"> 
    <div class = "excludeSaveWarnings">
        <table width="95%">
            <asp:TableRow>
                <asp:TableCell runat="server" ID="CellForTextBoxUserName" Width="200px">
                    <asp:Label SkinID="DataLabel" ID="LabelForTextBoxUserName" runat="server" 
                        Text="Username*:" 
                        Font-Bold="true" 
                        AssociatedControlID="TextBoxUserName">
                    </asp:Label>
                    <br />
                    <asp:TextBox ID="TextBoxUserName" runat="server" MaxLength="30" Width="90px" >
                    </asp:TextBox>
                    <br />
                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorUserName" runat="server" 
                        ControlToValidate = "TextBoxUserName" 
                        Display = "Dynamic" 
                        ErrorMessage="Username is required." 
                        SetFocusOnError = "true"
                        ValidationGroup="OnRunReport"
                        Enabled="true">
                    </asp:RequiredFieldValidator>  
                </asp:TableCell>
                <asp:TableCell runat="server" ID="CellForTextBoxReferralId" Width="200px">
                    <asp:Label SkinID="DataLabel" ID="LabelReferralId" runat="server" 
                        Text="Referral ID:" 
                        Font-Bold="true" 
                        AssociatedControlID="TextBoxReferralId">
                    </asp:Label>
                    <br />
                    <asp:TextBox ID="TextBoxReferralId" runat="server"
                        Width="90px"/>
                    <br />
                    <asp:RangeValidator runat="server" ID="RangeValidatorTextBoxReferralId"
                        Enabled="true"
                        ForeColor="Red"
                        Display="Dynamic"  
                        ValidationGroup="OnRunReport"
                        EnableClientScript="true"  
                        SetFocusOnError="true" 
                        Type="Integer"    
                        ControlToValidate = "TextBoxReferralId"                         
                        MinimumValue="0"
                        MaximumValue="2147483647"
                        ErrorMessage="Referral Id needs to be a positive integer number and less than 2,147,483,647.">
                    </asp:RangeValidator>
                </asp:TableCell><asp:TableCell runat="server" ID="CellForTextBoxDateFrom" Width="260px">
                    <asp:Label SkinID="DataLabel" ID="LabelDateFrom" runat="server" 
                        Text="Date From (mm/dd/yyyy):" 
                        Font-Bold="true" 
                        AssociatedControlID="TextBoxDateFrom">
                    </asp:Label>
                    <br />  
                    <asp:TextBox ID="TextBoxDateFrom" runat="server"
                        Width="90px"  
                    />
                    <br />
                    <asp:CompareValidator runat="server" ID="CompareValidatorTextBoxDateFrom" 
                        Enabled="true"
                        ForeColor="Red"  
                        Display="Dynamic"  
                        ValidationGroup="OnRunReport"
                        EnableClientScript="true"  
                        SetFocusOnError="true" 
                        Type="Date"    
                        ValueToCompare="01/01/4000" 
                        ControlToValidate = "TextBoxDateFrom"                         
                        Operator = "LessThanEqual" 
                        ErrorMessage="Date From needs to be in the following format: mm/dd/yyyy and today or earlier.">
                    </asp:CompareValidator>
               </asp:TableCell><asp:TableCell runat="server" ID="CellForTextBoxDateTo" Width="260px">
                    <asp:Label SkinID="DataLabel" ID="LabelDateTo" runat="server" 
                        Text="Date To (mm/dd/yyyy):" 
                        Font-Bold="true" 
                        AssociatedControlID="TextBoxDateTo">
                    </asp:Label>
                    <br />
                    <asp:TextBox ID="TextBoxDateTo" runat="server"
                        Width="90px"  
                    />
                    <br />
                    <asp:CompareValidator runat="server" ID="CompareValidatorTextBoxDateTo" 
                        Enabled="true"
                        ForeColor="Red"  
                        Display="Dynamic"  
                        ValidationGroup="OnRunReport"
                        EnableClientScript="true"  
                        SetFocusOnError="true" 
                        Type="Date"    
                        ValueToCompare="01/01/4000" 
                        ControlToValidate = "TextBoxDateTo"                         
                        Operator = "LessThanEqual" 
                        ErrorMessage="Date To needs to be in the following format: mm/dd/yyyy and today or earlier.">
                    </asp:CompareValidator>
                </asp:TableCell><asp:TableCell runat="server" ID="CellForListBoxVisns"  Width="120px">
                    <asp:Label SkinID="DataLabel" ID="LabelVisn" runat="server" 
                        Text="VISN:" 
                        Font-Bold="true" 
                        AssociatedControlID="ListBoxVisns">
                    </asp:Label>
                    <br />
                    <asp:ListBox ID="ListBoxVisns" runat="server"  
                        Rows="5" 
                        SelectionMode="Multiple" 
                        Enabled="true"
                        DataTextField="FullVISNName" 
                        DataValueField="ID" >
                    </asp:ListBox>
                </asp:TableCell><asp:TableCell runat="server" ID="CellForDropDownListYearDefinition" Width="220px">
                    <asp:Label SkinID="DataLabel" ID="LabelYearDefinition" runat="server" 
                        Text="Report Year Definition *:" 
                        Font-Bold="true" 
                        AssociatedControlID="DropDownListYearDefinition">
                    </asp:Label>
                    <br />
                    <asp:DropDownList ID="DropDownListYearDefinition" runat="server" >
                        <asp:ListItem Value="0">Select One</asp:ListItem>
                        <asp:ListItem Value="1">Fiscal Year</asp:ListItem>
                        <asp:ListItem Value="2">Calendar Year</asp:ListItem>
                    </asp:DropDownList>
                    <br />
                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorDropDownListYearDefinition" runat="server" 
                        Enabled="true"
                        ControlToValidate="DropDownListYearDefinition"  
                        EnableClientScript="true"
                        ErrorMessage="Report Year Definition is required." 
                        InitialValue="0"  
                        ValidationGroup="OnRunReport"
                        SetFocusOnError="true"
                        Display="Dynamic">
                    </asp:RequiredFieldValidator>
                </asp:TableCell><asp:TableCell runat="server" ID="CellForListBoxYearSelection" Width="220px">
                    <asp:Label SkinID="DataLabel" ID="LabelYearSelection" runat="server" 
                        Text="Report Year Selection:" 
                        Font-Bold="true" 
                        AssociatedControlID="ListBoxYearSelection">
                    </asp:Label>
                    <br />
                    <asp:ListBox ID="ListBoxYearSelection" runat="server"  
                        Rows="5" 
                        SelectionMode="Multiple" 
                        Enabled="true">
                    </asp:ListBox>
                </asp:TableCell><asp:TableCell runat="server" ID="TableCell16">
                        &nbsp;
                </asp:TableCell></asp:TableRow><tr>
               <td>
                    <asp:Button ID="ButtonRunReport" runat="server" 
                        Text="Run Report" 
                        Width="90px"  
                        ValidationGroup="OnRunReport"
                        onclick="ButtonRunReportClick" 
                        style="margin-left: 0px; margin-top: 8px"/>
                </td>
            </tr>
        </table>
    </div>
</asp:Panel>
<div class = "excludeSaveWarnings">
    <rsweb:ReportViewer ID="ReportViewerReport" runat="server"  
        Width="100%"
        ProcessingMode="Remote" Height="700px" >
    </rsweb:ReportViewer> 
</div>
<asp:ObjectDataSource ID="ObjectDataSourceRegistryVISNs" runat="server" 
    SelectMethod="GetVISNOnlyList" 
    TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"> 
</asp:ObjectDataSource>


